/*-------------------------------------*\
|  Joystick Functions - Adam Honse	|
|  See class definition in joystick.h	|
\*-------------------------------------*/

#include "joystick.h"

Joystick::Joystick(string dev)
{
  memset(&aPos, 0x00, sizeof(aPos));
  memset(&bPos, 0x00, sizeof(bPos));
  char padn[80];
  fd = open(dev.c_str(), O_RDONLY);
  if(fd <= 0)
  {
    cout << "Could not open " << dev << endl;
  }
  else
  {
    ioctl(fd, JSIOCGAXES, &axisCount);
    ioctl(fd, JSIOCGBUTTONS, &buttonCount);
    fcntl(fd, F_SETFL, O_NONBLOCK);
    ioctl(fd, JSIOCGNAME(80), padn);
  }
  padname.assign(padn);
  update();
}

Joystick::~Joystick()
{
  close(fd);
}

void Joystick::update()
{
  changed = false;
  for(int i = 0; i < 100; i++)
  {
    int result = read(fd, &ev, sizeof(ev));
    if(result > 0)
    {
      if( ev.type == JS_EVENT_AXIS)
      {
        aPos[ev.number] = ev.value;
        changed = true;
      }
      else if (ev.type == JS_EVENT_BUTTON)
      {
        bPos[ev.number] = ev.value;
        changed = true;
      }
    }
  }
}

int Joystick::poll_axis(int ax)
{
  if(ax < MAX_AXIS)
  {
    return aPos[ax];
  }
}

int Joystick::poll_button(int bt)
{
  if(bt < MAX_BUTTONS)
  {
    return bPos[bt];
  }
}

string Joystick::get_name()
{
  return padname;
}

bool Joystick::has_changed()
{
  return changed;
}
